﻿<%@ Page language="c#" codePage="1200" AutoEventWireup="false" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="System.Collections.Generic" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
	<meta http-equiv="Content-Type" content="text/html; charset=unicode">
<title>Zestawienie obrotów wg typow dokumentow</title>
	<script runat="server">
	Hashtable konta = new Hashtable();
	  ObrotyKontaWorker.Params p = null;
	
	void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
	  decimal winien = 0m, ma = 0m;
	  KontoBase konto = (KontoBase)args.Row;
	  Soneta.Business.View zapisy = null;
	  if (konto.SubKonta.IsEmpty)
	  {
		zapisy = new SubTable(KsiegaModule.GetInstance(konto).ZapisyKsiegowe.WgKonto[konto,TypDziennika.Dekret],p.Okres).CreateView();
	  }
	  else
	  {
		zapisy = new SubTable(KsiegaModule.GetInstance(konto).ZapisyKsiegowe.WgOkres[konto.Okres, TypDziennika.Dekret], p.Okres).CreateView();
		zapisy.Condition = new FieldCondition.Like("Konto.Symbol",konto.Symbol+KontoBase.Separator+"*");
	  }
	  
	  if(param.TypDokumentu!=TypDokumentu.Niezdefiniowany)
		zapisy.Condition &= new FieldCondition.Equal("Dekret.Ewidencja.Typ",param.TypDokumentu);

	  
	  if(param.DefinicjaDokumentu!=null)
		zapisy.Condition &= new FieldCondition.Equal("DefinicjaEwidencji",param.DefinicjaDokumentu);

	  
	  if(!p.Bufor)
		zapisy.Condition &= new FieldCondition.Equal("Bufor",p.Bufor);
		  
	  foreach (ZapisKsiegowy z in zapisy)
	  {
		winien += z.Winien.Value;
		ma += z.Ma.Value;
	  }
	   
	  colObrotyWn.EditValue = winien;
	  colObrotyMa.EditValue = ma;

	  if (param.Niezerowe && winien == 0m && ma == 0m)
		args.VisibleRow = false;
	}
	
	void ZestawienieObrotówISald_OnLoad(Object sender, EventArgs args){
	  p  = (ObrotyKontaWorker.Params)DataContext1.Get(typeof(ObrotyKontaWorker.Params));
	  OkresObrachunkowy o         = (OkresObrachunkowy)DataContext1.Get(typeof(OkresObrachunkowy));
	  Konta.Params p1             = (Konta.Params)DataContext1.Get(typeof(Konta.Params));
	  
	  ReportHeader1.Title = 
		string.Format(ReportHeader1.Title,
		 o, p.Okres,
		 p1.Typ, p1.Systematyka, p.Bufor ? "Tak" : "Nie",  CalcOpisNiezerowe(p1),
		 p1.Filtr, p1.OdKonta, p1.DoKonta, param.TypDokumentu, param.DefinicjaDokumentu);
	}


		private string CalcOpisNiezerowe(Konta.Params p1)
		{
			var items = new List<String>();

			if(p1.Niezerowe)
				items.Add("Niezerowe obroty");
			if(p1.NiezeroweSalda)
				items.Add("Niezerowe salda");
			if(p1.NiezeroweSaldaBO)
				items.Add("Niezerowe salda BO");

			if (items.Count == 0)
				return string.Empty;
			if (items.Count == 1)
				return "|" + items[0] + ": Tak";

			return "|" + string.Join(p1.NiezeroweCond == Konta.Params.NiezeroweWarunek.CondAnd ? " i ": " lub ", items);
		}


	  Params param = null;
	  [Context]
	  public Params Param
	  {
		set { param = value; }
	  }

	  public class Params : ContextBase
	  {
		public Params(Context cx)
		  : base(cx)
		{
		  niezerowe = ((Konta.Params)cx[typeof(Konta.Params)]).Niezerowe;
		}

		TypDokumentu typDokumentu = TypDokumentu.Niezdefiniowany;
		[Caption("Typ dokumentu")]
		[Priority(1)]
		public TypDokumentu TypDokumentu
		{
		  get { return typDokumentu; }
		  set
		  {
			typDokumentu = value;
			definicjaDokumentu = null;
			OnChanged(EventArgs.Empty);
		  }
		}

		public TypDokumentu[] GetListTypDokumentu()
		{
		  return
						CoreModule.GetInstance(this).Config.EwidencjaDokumentów.UkryjTypyEwidencji.UkryjTypy(
							DokEwidencja.TypyDokumentowEwidencji(Session, true)
						);
		}        

		DefinicjaDokumentu definicjaDokumentu = null;
		[Caption("Definicja dokumentu")]
		[Priority(2)]
		public DefinicjaDokumentu DefinicjaDokumentu
		{
		  get { return definicjaDokumentu; }
		  set
		  {
			definicjaDokumentu = value;
			OnChanged(EventArgs.Empty);            
		  }
		}

		public LookupInfo GetListDefinicjaDokumentu()
		{
		  return
							new LookupInfo(CoreModule.GetInstance(Session).DefDokumentow.WgTypu[TypDokumentu]);
		}

		bool niezerowe = true;
		[Caption("Niezerowe obroty")]
		[Priority(3)]
		public bool Niezerowe
		{
		  get { return niezerowe; }
		  set { niezerowe = value; OnChanged(EventArgs.Empty); }
		}             
		
	  }
	  
	
	</script>
	
	<meta name="GENERATOR" Content="Microsoft Visual Studio 7.0">
	<meta name="CODE_LANGUAGE" Content="C#">
	<meta name="vs_defaultClientScript" content="JavaScript">
	<meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
  </HEAD>
  <body>
	<form id="ZestawienieObrotówISald" method="post" onload="ZestawienieObrotówISald_OnLoad" runat="server">
	  <ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[], Soneta.Business"></ea:DataContext><BR>
	  <cc1:ReportHeader id="ReportHeader1" title="Zestawienie obrotów wg typów i definicji dokumentów | Okres obrachunkowy: {0}, Za okres: {1} | Typ kont: {2}, Systematyka: {3} | Typ: {9}, Definicja: {10}, Uwzględniać bufor: {4}{5}| Filtr: {6} | Od konta: {7} | Do konta: {8}" runat="server"></cc1:ReportHeader><BR>
	  <BR>
	  <ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Ksiega.KontoBase, Soneta.Ksiega, Version=1.0.1117.20240, Culture=neutral, PublicKeyToken=null" RowsInRow="1" ShowPrevAgrSum="InFooter" ShowAgrSum="True" ShowPageSum="True">
		<Columns>
		  <ea:GridColumn Width="40" DataMember="Symbol" ID="colSymbol" EncodeHTML="true" ></ea:GridColumn>
		  <ea:GridColumn Width="40" DataMember="Nazwa" Total="Info" ID="colNazwa" EncodeHTML="true" ></ea:GridColumn>
		  <ea:GridColumn Align="Right" Total="Sum" Caption="Obroty Wn" Format="{0:n}" ID="colObrotyWn"></ea:GridColumn>
		  <ea:GridColumn Align="Right" Total="Sum" Caption="Obroty Ma" Format="{0:n}" ID="colObrotyMa"></ea:GridColumn>
	   </Columns>
	  </ea:Grid><BR>
	  <cc1:ReportFooter id="ReportFooter1" runat="server">
		<Subtitles>
		  <cc1:FooterSubtitle SubtitleType="OperatorCzas"></cc1:FooterSubtitle>
		</Subtitles>
	  </cc1:ReportFooter>
	</form>
  </body>
</HTML>
